# Aggressor Adventures Document Library

A self-contained LAMP (Linux/Apache/PHP) web application for serving PDF documents on an Ubuntu-based onboard intranet. The application scans folder hierarchies to build a document library without requiring a database or admin panel.

## Features

- **File-based Document Management**: No database required - simply add/remove PDF files
- **Responsive Design**: Mobile-first approach optimized for tablets and laptops
- **Real-time Search**: Filter documents across all categories by filename or description
- **Embedded PDF Viewer**: View documents without leaving the page
- **Aggressor Branding**: Matches the look and feel of aggressor.com
- **Touch-friendly Interface**: Optimized for yacht Wi-Fi and touch interactions
- **Security**: Built-in protection against common web vulnerabilities

## Directory Structure

```
/var/www/html/docs/
├── index.php                 # Main application file
├── assets/
│   ├── style.css            # Aggressor-branded responsive CSS
│   └── script.js            # JavaScript for search and PDF viewing
├── .htaccess                # Apache configuration
├── docs/                    # Document storage directory
│   ├── Safety/              # Category folder
│   │   ├── emergency-procedures.pdf
│   │   ├── emergency-procedures.json  # Optional metadata
│   │   └── safety-briefing.pdf
│   ├── Dive Information/    # Another category
│   │   ├── dive-sites.pdf
│   │   └── equipment-guide.pdf
│   └── Itineraries/         # Third category
│       ├── 7-day-bahamas.pdf
│       └── 10-day-belize.pdf
└── README.md               # This file
```

## Installation & Deployment

### Prerequisites

- Ubuntu server with Apache 2.4+
- PHP 7.4+ with required modules
- Web server with document root access

### Step 1: Install Required Packages

```bash
sudo apt update
sudo apt install apache2 php libapache2-mod-php php-json php-mbstring
```

### Step 2: Enable Apache Modules

```bash
sudo a2enmod rewrite
sudo a2enmod headers
sudo a2enmod expires
sudo a2enmod deflate
sudo systemctl restart apache2
```

### Step 3: Deploy Application Files

1. Copy all application files to your web directory:
```bash
sudo cp -r * /var/www/html/docs/
```

2. Set proper permissions:
```bash
sudo chown -R www-data:www-data /var/www/html/docs/
sudo chmod -R 755 /var/www/html/docs/
sudo chmod 644 /var/www/html/docs/.htaccess
```

3. Create the docs directory if it doesn't exist:
```bash
sudo mkdir -p /var/www/html/docs/docs/
sudo chown www-data:www-data /var/www/html/docs/docs/
```

### Step 4: Configure Apache Virtual Host

Create or modify your Apache virtual host configuration:

```apache
<VirtualHost *:80>
    ServerName your-yacht-domain.local
    DocumentRoot /var/www/html/docs
    
    <Directory /var/www/html/docs>
        AllowOverride All
        Require all granted
        Options -Indexes +FollowSymLinks
    </Directory>
    
    # Optional: Redirect to HTTPS if SSL is configured
    # Redirect permanent / https://your-yacht-domain.local/
    
    ErrorLog ${APACHE_LOG_DIR}/docs_error.log
    CustomLog ${APACHE_LOG_DIR}/docs_access.log combined
</VirtualHost>
```

### Step 5: Test Installation

1. Restart Apache:
```bash
sudo systemctl restart apache2
```

2. Visit your application in a web browser:
```
http://your-yacht-domain.local/
```

## Adding Documents

### Basic Document Addition

1. Create category folders under `/var/www/html/docs/docs/`:
```bash
sudo mkdir -p "/var/www/html/docs/docs/Safety"
sudo mkdir -p "/var/www/html/docs/docs/Dive Information"
sudo mkdir -p "/var/www/html/docs/docs/Itineraries"
```

2. Copy PDF files to the appropriate category folders:
```bash
sudo cp emergency-procedures.pdf "/var/www/html/docs/docs/Safety/"
sudo cp dive-sites.pdf "/var/www/html/docs/docs/Dive Information/"
```

3. Set proper permissions:
```bash
sudo chown -R www-data:www-data /var/www/html/docs/docs/
sudo chmod -R 644 /var/www/html/docs/docs/*.pdf
```

### Adding Document Descriptions (Optional)

Create a `.json` or `.txt` file with the same name as your PDF to add descriptions:

**JSON format** (`emergency-procedures.json`):
```json
{
    "description": "Complete emergency procedures for all diving operations including medical emergencies, equipment failures, and evacuation protocols."
}
```

**Text format** (`emergency-procedures.txt`):
```
Complete emergency procedures for all diving operations including medical emergencies, equipment failures, and evacuation protocols.
```

## Configuration Options

### Customizing Categories

Category names are determined by folder names. To change a category:

1. Rename the folder:
```bash
sudo mv "/var/www/html/docs/docs/Old Name" "/var/www/html/docs/docs/New Name"
```

2. The change will be reflected immediately (no restart required)

### Security Configuration

The `.htaccess` file includes several security measures:

- **File Type Restrictions**: Only PDF, JSON, and TXT files are accessible in the docs directory
- **Directory Protection**: Prevents direct access to sensitive files
- **Security Headers**: Includes XSS protection, clickjacking prevention, and content type sniffing protection
- **Access Control**: Blocks access to system files and version control directories

### Performance Optimization

The application includes several performance optimizations:

- **Compression**: Gzip compression for CSS, JavaScript, and HTML
- **Caching**: Browser caching headers for static assets
- **Efficient Scanning**: Directory scanning is optimized for fast loading

## Troubleshooting

### Common Issues

1. **"No Documents Found" message**:
   - Check that the `docs/` directory exists
   - Verify PDF files are in category subdirectories
   - Check file permissions (should be readable by www-data)

2. **PDF files not displaying**:
   - Ensure PDF files are valid and not corrupted
   - Check browser console for JavaScript errors
   - Verify Apache has proper MIME type configuration

3. **Search not working**:
   - Check browser console for JavaScript errors
   - Ensure the search input element has the correct ID
   - Verify JavaScript file is loading properly

4. **Permission errors**:
```bash
sudo chown -R www-data:www-data /var/www/html/docs/
sudo chmod -R 755 /var/www/html/docs/
sudo chmod -R 644 /var/www/html/docs/docs/*.pdf
```

### Log Files

Check Apache error logs for issues:
```bash
sudo tail -f /var/log/apache2/error.log
sudo tail -f /var/log/apache2/docs_error.log
```

## Browser Compatibility

The application is tested and optimized for:

- **Modern tablets**: iPad, Android tablets
- **Laptops**: Chrome, Firefox, Safari, Edge
- **Mobile devices**: iOS Safari, Chrome Mobile
- **Touch interfaces**: Optimized for touch navigation

## Maintenance

### Regular Tasks

1. **Monitor disk space**: PDF files can accumulate over time
2. **Update documents**: Replace outdated files as needed
3. **Check logs**: Monitor access and error logs for issues
4. **Backup documents**: Regular backups of the docs/ directory

### Updates

To update the application:

1. Backup your current docs/ directory
2. Replace application files (index.php, assets/, .htaccess)
3. Restore your docs/ directory
4. Test functionality

## Support

For technical support or questions about this document library system, refer to the application source code comments or contact your system administrator.
