<?php
/**
 * MAMP Test File for Aggressor Document Library
 * Use this to debug PHP issues in MAMP
 */

// Enable error reporting
error_reporting(E_ALL);
ini_set('display_errors', 1);

echo "<h1>MAMP PHP Test</h1>";

// Test PHP version
echo "<h2>PHP Version</h2>";
echo "PHP Version: " . phpversion() . "<br>";

// Test directory access
echo "<h2>Directory Tests</h2>";
$docsDir = __DIR__ . '/docs';
echo "Docs directory path: " . $docsDir . "<br>";
echo "Docs directory exists: " . (is_dir($docsDir) ? 'YES' : 'NO') . "<br>";
echo "Docs directory readable: " . (is_readable($docsDir) ? 'YES' : 'NO') . "<br>";

// Test array syntax
echo "<h2>Array Syntax Test</h2>";
$testArray = array('pdf', 'json', 'txt');
echo "Old array syntax works: " . (count($testArray) === 3 ? 'YES' : 'NO') . "<br>";

// Test if docs directory has content
if (is_dir($docsDir)) {
    echo "<h2>Directory Contents</h2>";
    $contents = scandir($docsDir);
    echo "Contents of docs directory:<br>";
    foreach ($contents as $item) {
        if ($item !== '.' && $item !== '..') {
            echo "- " . $item . " (" . (is_dir($docsDir . '/' . $item) ? 'directory' : 'file') . ")<br>";
        }
    }
} else {
    echo "<h2>Creating docs directory...</h2>";
    if (mkdir($docsDir, 0755, true)) {
        echo "Docs directory created successfully<br>";
    } else {
        echo "Failed to create docs directory<br>";
    }
}

// Test function definitions
echo "<h2>Function Tests</h2>";
echo "scandir function exists: " . (function_exists('scandir') ? 'YES' : 'NO') . "<br>";
echo "pathinfo function exists: " . (function_exists('pathinfo') ? 'YES' : 'NO') . "<br>";
echo "filesize function exists: " . (function_exists('filesize') ? 'YES' : 'NO') . "<br>";

// Test constants
echo "<h2>Constants Test</h2>";
define('TEST_CONSTANT', 'test_value');
echo "Constants work: " . (TEST_CONSTANT === 'test_value' ? 'YES' : 'NO') . "<br>";

echo "<h2>Test Complete</h2>";
echo "If you see this message, basic PHP functionality is working.<br>";
echo "You can now try accessing index.php<br>";
?>
